using System;
using System.Xml;
using System.Configuration;
using System.Reflection;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace XMLShapeLib
{
    /// <summary>
    /// Export options
    /// </summary>
    public enum EDIName
    {
        [Description(@"Generic\Orders")]
        Orders,
        [Description(@"Generic\Products")]
        Products,
        [Description(@"Generic\Customers")]
        Customers
    }

    public class Utils
    {
        public static string VOLUSION_BASE_API;
        public static string VOLUSION_USER;
        public static string VOLUSION_PASSWORD;

        /// <summary>
        /// Gets the API URL For generic exports
        /// </summary>
        /// <param name="eDIName"></param>
        /// <returns></returns>
        public static string GetAPIGenericURL(EDIName eDIName)
        {
            return string.Format("{0}?Login={1}&EncryptedPassword={2}&EDI_Name={3}&SELECT_Columns=*", VOLUSION_BASE_API, VOLUSION_USER, VOLUSION_PASSWORD, GetEnumDescription(eDIName));
        }

        /// <summary>
        /// Gets the Description tag value from an enum
        /// </summary>
        /// <param name="value">The enum</param>
        /// <returns>The Description dag value as a string</returns>
        public static string GetEnumDescription(Enum value)
        {
            FieldInfo fi = value.GetType().GetField(value.ToString());
            DescriptionAttribute[] attributes = (DescriptionAttribute[])fi.GetCustomAttributes(typeof(DescriptionAttribute), false);
            return (attributes.Length > 0) ? attributes[0].Description : value.ToString();
        }

        /// <summary>
        /// Gets back an XML Document from a URL
        /// </summary>
        /// <param name="APIURL">The URL</param>
        /// <returns>The XML Document</returns>
        public static XmlDocument GetXMLFromURL(string APIURL)
        {
            XmlDocument APIDoc = null;
            try
            {
                XmlTextReader reader = new XmlTextReader(APIURL);
                APIDoc = new XmlDocument();
                APIDoc.Load(reader);
                reader.Close();
            }
            catch (Exception e)
            {
                throw new Exception("Error reading API URL", e);
            }
            return APIDoc;
        }

        public static List<string> AvailableMaps()
        {
            List<string> mapList = new List<string>();
            XmlDocument mapDoc = Utils.GetXMLFromURL(Environment.CurrentDirectory + "\\XMLConfig\\Mapper.xml");
            XmlNodeList mapNodes = mapDoc.SelectNodes("//Map");
            foreach (XmlNode mapNode in mapNodes)
                mapList.Add(mapNode.Attributes["MapName"].InnerText);
            return mapList;

        }
    }
}
