using System;
using System.Xml;
using System.Collections.Generic;
using System.Text;

namespace XMLShapeLib
{
    public class Mapper
    {
        #region Properties
        private Dictionary<string, string> _tagDictionary = new Dictionary<string, string>();

        public Dictionary<string, string> TagDictionary
        {
            get
            {
                return _tagDictionary;
            }
            set
            {
                _tagDictionary = value;
            }
        } 
        #endregion

        public Mapper(string mapName)
        {
            LoadMapper(mapName);
        }

        private void LoadMapper(string mapName)
        {
            XmlDocument mapDoc = Utils.GetXMLFromURL(Environment.CurrentDirectory + "\\XMLConfig\\Mapper.xml");
            XmlNode mapNode = mapDoc.SelectSingleNode("//Map[@MapName='" + mapName + "']");
            foreach (XmlNode mapKey in mapNode.ChildNodes)
            {
                TagDictionary.Add(mapKey.Name, mapKey.InnerText);
            }
        }
    }
}
