using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using XMLShapeLib;

namespace VAPIShape
{
    public partial class SettingsForm : Form
    {
        public SettingsForm()
        {
            InitializeComponent();
            
            if (string.IsNullOrEmpty(Properties.Settings.Default.VOLUSION_BASE_API))
                APIURLTextBox.Text = "http://www.yourdomain.com/net/WebService.aspx";
            else
                APIURLTextBox.Text = Properties.Settings.Default.VOLUSION_BASE_API;

            if (string.IsNullOrEmpty(Properties.Settings.Default.VOLUSION_USER))
                userTextBox.Text = "YourEmail@YourDomain.com";
            else
                userTextBox.Text = Properties.Settings.Default.VOLUSION_USER;
            
            if (string.IsNullOrEmpty(Properties.Settings.Default.VOLUSION_PASSWORD))
                passwordTextBox.Text = "YourPassword";
            else
                passwordTextBox.Text = Properties.Settings.Default.VOLUSION_PASSWORD;
        }

        private void saveButton_Click(object sender, EventArgs e)
        {
            try
            {
                Properties.Settings.Default.VOLUSION_USER = userTextBox.Text;
                Properties.Settings.Default.VOLUSION_PASSWORD = passwordTextBox.Text;
                Properties.Settings.Default.VOLUSION_BASE_API = APIURLTextBox.Text;
                Utils.VOLUSION_USER = Properties.Settings.Default.VOLUSION_USER;
                Utils.VOLUSION_PASSWORD = Properties.Settings.Default.VOLUSION_PASSWORD;
                Utils.VOLUSION_BASE_API = Properties.Settings.Default.VOLUSION_BASE_API;
                Properties.Settings.Default.Save();
                this.Close();
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error saving user settings" + ex.Message);
            }
        }
    }
}