using System;
using System.IO;
using System.Xml;
using System.Threading;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using XMLShapeLib;

namespace VAPIShape
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            optionComboBox.DataSource = Utils.AvailableMaps();
            Utils.VOLUSION_USER = Properties.Settings.Default.VOLUSION_USER;
            Utils.VOLUSION_PASSWORD = Properties.Settings.Default.VOLUSION_PASSWORD;
            Utils.VOLUSION_BASE_API = Properties.Settings.Default.VOLUSION_BASE_API;
            if (string.IsNullOrEmpty(Utils.VOLUSION_USER) || string.IsNullOrEmpty(Utils.VOLUSION_PASSWORD) || string.IsNullOrEmpty(Utils.VOLUSION_BASE_API))
                userSettingsToolStripMenuItem_Click(this, new EventArgs());
        }

        /// <summary>
        /// Gets a formatted XML string in the specified format
        /// </summary>
        /// <param name="format">The format to get the data</param>
        /// <returns>XML string</returns>
        public string GetFormatedXML(string format)
        {
            XmlDocument doc = Utils.GetXMLFromURL(Utils.GetAPIGenericURL(EDIName.Orders));
            //Remove the XML declaration tag
            doc.RemoveChild(doc.FirstChild);
            return XMLShaper.GetXMLAs(doc.InnerXml, format);
        }

        /// <summary>
        /// Write the XML String into a file
        /// </summary>
        /// <param name="stateInfo">This is set from the calling thread</param>
        private void WriteFormatedXML(Object stateInfo)
        {
            Stream fileStream;
            string xmlData = string.Empty;
            if ((fileStream = mainSaveFileDialog.OpenFile()) != null)
            {
                try
                {
                    ASCIIEncoding encoder = new ASCIIEncoding();
                    xmlData = GetFormatedXML(stateInfo.ToString());
                    byte[] data = encoder.GetBytes(xmlData);
                    fileStream.Write(data, 0, data.Length);
                    fileStream.Close();
                }
                catch (Exception e)
                {
                    MessageBox.Show("Error Saving XML " + e.Message);
                }
            }
            SetText(xmlData);
        }

        delegate void SetTextCallback(string text);

        private void SetText(string text)
        {
            if (this.XMLTextBox.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(SetText);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                if (previewCheckBox.Checked) this.XMLTextBox.Text = text;
                this.exportButton.Enabled = true;
                Cursor.Current = Cursors.Default;
            }
        }

        #region Events
        private void exportButton_Click(object sender, EventArgs e)
        {
            if (!IsFormValid()) return;

            if (mainSaveFileDialog.ShowDialog() == DialogResult.OK)
            {
                exportButton.Enabled = false;
                Cursor.Current = Cursors.WaitCursor;
                ThreadPool.QueueUserWorkItem(new WaitCallback(WriteFormatedXML), optionComboBox.SelectedItem.ToString());
            }
        }

        private void previewCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            XMLTextBox.Enabled = previewCheckBox.Checked;
        }

        private void userSettingsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SettingsForm settings = new SettingsForm();
            settings.ShowDialog();
        }

        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            Application.Exit();
        }
        #endregion

        #region Validation
        public bool IsFormValid()
        {
           
            if (!IsOptionValid())
            {
                typeErrorProvider.SetError(optionComboBox, "Please enter code.");
                return false;
            }else{
                typeErrorProvider.SetError(optionComboBox, string.Empty);
            }
            return true;
        }

        private bool IsOptionValid()
        {
             return (optionComboBox.SelectedItem != null);
        }

        #endregion

        
    }
}