using System;
using System.IO;
using System.Xml;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;


using APIReaderLib;
using APIReaderLib.DataObjects;

namespace VAPIReader
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        #region Events
        private void productsButton_Click(object sender, EventArgs e)
        {
            string productsURL = APIReaderLib.Utils.GetAPIGenericURL(EDIName.Products);
            BindGrid(productsURL);
        }

        private void ordersButton_Click(object sender, EventArgs e)
        {
            string ordersURL = Utils.GetAPIGenericURL(EDIName.Orders);
            BindGrid(ordersURL);
        }

        private void customersButton_Click(object sender, EventArgs e)
        {
            string customersURL = Utils.GetAPIGenericURL(EDIName.Customers);
            BindGrid(customersURL);
        }

        private void productsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string productsURL = APIReaderLib.Utils.GetAPIGenericURL(EDIName.Products);
            BindGrid(productsURL);
        }

        private void customersToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string ordersURL = Utils.GetAPIGenericURL(EDIName.Orders);
            BindGrid(ordersURL);
        }

        private void ordersToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string customersURL = Utils.GetAPIGenericURL(EDIName.Customers);
            BindGrid(customersURL);
        }

        private void createNewProductToolStripMenuItem_Click(object sender, EventArgs e)
        {
            AddProductForm addForm = new AddProductForm();
            addForm.ShowDialog();
        }

        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            Application.Exit();
        }
        #endregion

        #region Data Binding
        /// <summary>
        /// Binds the grid to a an API Call
        /// </summary>
        /// <param name="URL"></param>
        public void BindGrid(string URL)
        {
            try
            {
                XMLPostManager manager = new XMLPostManager();
                XmlDocument doc = manager.GetXMLFromURL(URL);
                MemoryStream ms = new MemoryStream();
                doc.Save(ms);
                ms.Seek(0, 0);
                DataSet Ds = new DataSet();
                Ds.ReadXml(ms, XmlReadMode.Auto);
                if (Ds.Tables.Count > 0)
                {
                    mainDataGrid.DataSource = Ds;
                    mainDataGrid.Refresh();
                }
                else
                {
                    MessageBox.Show("No new data to display");
                }
            }
            catch (Exception e)
            {
                MessageBox.Show("Error binding grid: " + e.Message);
            }
        } 
        #endregion
    }
}