using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using APIReaderLib;
using APIReaderLib.DataObjects;

namespace VAPIReader
{
    public partial class AddProductForm : Form
    {
        public AddProductForm()
        {
            InitializeComponent();
        }

        #region Events
        private void addButton_Click(object sender, EventArgs e)
        {
            if (IsFormValid())
            {
                //Add a product
                try
                {
                    AddProduct(nameTextBox.Text, codeTextBox.Text, priceTextBox.Text);
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Error adding product " + ex.Message);
                }
                this.Close();
            }
        } 
        #endregion

        public void AddProduct(string productName, string productCode, string productPrice)
        {
            //Create a new product
            xmldata data = new xmldata();
            data.Items = new xmldataProducts[1];
            data.Items[0] = new xmldataProducts();
            //Populate the product fields here
            data.Items[0].ProductName = productName;
            data.Items[0].ProductCode = productCode;
            data.Items[0].ProductPrice = productPrice;

            string productXML = Utils.GetProductXML(data);
            string APIURL = Utils.GetAPIPostURL(ImportMode.Insert);
            XMLPostManager manager = new XMLPostManager();
            string response = manager.SendXMLToURL(APIURL, productXML);
            MessageBox.Show(response);
        }

        #region Validation
        public bool IsFormValid()
        {
            if (!IsNameValid())
            {
                nameErrorProvider.SetError(nameTextBox, "Please enter name.");
                return false;
            }
            else
            {
                nameErrorProvider.SetError(nameTextBox, string.Empty);
            }
            if (!IsCodeValid())
            {
                codeErrorProvider.SetError(codeTextBox, "Please enter code.");
                return false;
            }
            else
            {
                codeErrorProvider.SetError(codeTextBox, string.Empty);
            }
            if (!IsPriceValid())
            {
                priceErrorProvider.SetError(priceTextBox, "Please enter a numeric price.");
                return false;
            }
            else
            {
                priceErrorProvider.SetError(priceTextBox, string.Empty);
            }
            return true;
        }

        private bool IsNameValid()
        {
            return (nameTextBox.Text.Trim().Length > 0);
        }

        private bool IsCodeValid()
        {
            return (codeTextBox.Text.Trim().Length > 0);
        }

        private bool IsPriceValid()
        {
            float price = 0;
            return float.TryParse(priceTextBox.Text, out price);
        } 
        #endregion

    }
}