using System;
using System.Xml;
using System.Xml.Serialization;
using System.Configuration;
using System.Reflection;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace APIReaderLib
{
    /// <summary>
    /// Import Options
    /// </summary>
    public enum ImportMode
    {
        [Description("Insert")]
        Insert,
        [Description("Insert-Update")]
        InsertUpdate,
        [Description("Insert-Truncate")]
        InsertTruncate,
        [Description("Update")]
        Update,
        [Description("Delete")]
        Delete
    }

    /// <summary>
    /// Export options
    /// </summary>
    public enum EDIName
    {
        [Description(@"Generic\Orders")]
        Orders,
        [Description(@"Generic\Products")]
        Products,
        [Description(@"Generic\Customers")]
        Customers
    }

    public class Utils
    {
        public static readonly string VOLUSION_BASE_API = ConfigurationManager.AppSettings["VOLUSION_BASE_API"];
        public static readonly string VOLUSION_USER = ConfigurationManager.AppSettings["VOLUSION_USER"];
        public static readonly string VOLUSION_PASSWORD = ConfigurationManager.AppSettings["VOLUSION_PASSWORD"];
        
        /// <summary>
        /// Gets the API URL to post to
        /// </summary>
        /// <param name="importMode">The impost Mode option</param>
        /// <returns>The API URL as string</returns>
        public static string GetAPIPostURL(ImportMode importMode)
        {
            return string.Format("{0}?Login={1}&EncryptedPassword={2}&Import={3}", VOLUSION_BASE_API, VOLUSION_USER, VOLUSION_PASSWORD, GetEnumDescription(importMode));
        }

        /// <summary>
        /// Gets the API URL For generic exports
        /// </summary>
        /// <param name="eDIName"></param>
        /// <returns></returns>
        public static string GetAPIGenericURL(EDIName eDIName)
        {
            return string.Format("{0}?Login={1}&EncryptedPassword={2}&EDI_Name={3}&SELECT_Columns=*", VOLUSION_BASE_API, VOLUSION_USER, VOLUSION_PASSWORD, GetEnumDescription(eDIName));
        }

        /// <summary>
        /// Gets the Description tag value from an enum
        /// </summary>
        /// <param name="value">The enum</param>
        /// <returns>The Description dag value as a string</returns>
        public static string GetEnumDescription(Enum value)
        {
            FieldInfo fi = value.GetType().GetField(value.ToString());
            DescriptionAttribute[] attributes = (DescriptionAttribute[])fi.GetCustomAttributes(typeof(DescriptionAttribute), false);
            return (attributes.Length > 0) ? attributes[0].Description : value.ToString();
        }

        /// <summary>
        /// Serialize a product object to XML
        /// </summary>
        /// <param name="product">The product</param>
        /// <returns>XML String</returns>
        public static string GetProductXML(DataObjects.xmldata product)
        {
            StringBuilder productSb = new StringBuilder();
            try
            {
                XmlWriter writer = XmlWriter.Create(productSb);
                XmlSerializer serializer = new XmlSerializer(typeof(DataObjects.xmldata));
                serializer.Serialize(writer, product);
            }catch(Exception e){
                throw new Exception("Cannot serialize product", e);
            }

            return productSb.ToString().Replace("<?xml version=\"1.0\" encoding=\"utf-16\"?>", string.Empty);
        }
    }

}
